package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MessageBusinessFromEnum {

    /**
     * 评价工作管理
     */
    evaluate("评价工作管理", 101),
    /**
     * 隐患排查
     */
    scene("隐患排查", 102),
    /**
     * 职业病危害因素检测
     */
    harmfactorTest("职业病危害因素检测", 103),
    /**
     * 工作计划
     */
    workPlan("工作计划", 104),
    /**
     * 隐患治理
     */
    reform("隐患治理", 201),
    /**
     * 监管集团版通知公告
     */
    blocNotice("监管集团版通知公告", 301),
    /**
     * 监管通知公告
     */
    superviseNotice("监管通知公告", 302),
    /**
     * 运维培训视频通知公告
     */
    maintenanceTrainingVideo("运维培训视频通知公告", 303),
    /**
     * 法律法规消息
     */
    law("法律法规", 401),
    /**
     * 系统更新
     */
    systemUpdate("系统通知", 501),
    /**
     * 在线培训
     */
    onlineTraining("在线培训", 601),
    ;

    private String name;
    private Integer value;

    private MessageBusinessFromEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (MessageBusinessFromEnum c : MessageBusinessFromEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer index) {
        this.value = index;
    }
}