package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 设定为管理员
 * 1、超级管理员
 * 2、普通管理员
 * 3、普通用户
 * 0、权限不变
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ManagerTypeEnum {


	/**
	 * 权限不变
	 */
	notChange("权限不变", (byte) 0),
	
	/**
	 * 超级管理员
	 */
	superAdmin("超级管理员", (byte) 1),

	/**
	 * 普通管理员
	 */
	admin("普通管理员", (byte) 2),
	/**
	 * 普通用户
	 */
	user("普通用户", (byte) 3),
	

	;


	// 成员变量
	private String name;
	private Byte value;
	// 构造方法

	private ManagerTypeEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(ManagerTypeEnum type : ManagerTypeEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

}
