package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 反馈类型枚举
 */

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FeedBackTypeEnum {
    /**
     * 1.体检
     */
    check("体检", (byte) 1),
    /**
     * 2、评价
     */
    evaluate("评价", (byte) 2),
    /**
     * 3、培训
     */
    train("培训", (byte) 3),
    /**
     * 4、职业病人
     */
    disease("职业病人", (byte) 4),
    /**
     * 5、检测
     */
    test("检测", (byte) 5),
    ;
    // 成员变量
    private String name;
    private Byte value;
    // 构造方法

    private FeedBackTypeEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }
    public static String getNameByValue(Byte value){
        if(value==null){
            return "";
        }
        for(FeedBackTypeEnum type : FeedBackTypeEnum.values()){
            if(type.getValue().equals(value)){
                return type.getName();
            }
        }
        return "";
    }
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the value
     */
    public Byte getValue() {
        return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public void setValue(Byte value) {
        this.value = value;
    }
}
