package cn.smarthse.modules.health.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ActionEnum {


	/**
	 * 新增
	 */
	add("新增", (byte) 1,"add"),
	/**
	 * 编辑
	 */
	edit("编辑", (byte) 2,"edit"),
	/**
	 * 查看
	 */
	view("查看", (byte) 3,"view"),

	;

	
	// 成员变量
	private String name;
	private Byte value;
	private String code;
	// 构造方法

	private ActionEnum(String name, Byte value,String code) {
		this.name = name;
		this.value = value;
		this.code=code;
	}
	
	public static String getNameByValue(Byte value){
		if(value==null){
			return "";
		}
		for(ActionEnum type : ActionEnum.values()){
			if(type.getValue().equals(value)){
				return type.getName();
			}
		}
		return "";
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	
}
