package cn.smarthse.modules.health.enums.staff;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 《》
 *
 *
 * @Project: smarthse-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <人员岗位属性>
 * @JDK version used:      <JDK1.7>
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2017年6月20日-下午2:22:10
 */
@Getter
@AllArgsConstructor
public enum StaffWorkPropertyEnum {
    MAJOR("主岗位", (byte) 1),
    PLURALITY("兼职岗位", (byte) 2),
    WORKED("经历", (byte) 3);// 这个值主要用于新增厂内外工作经历的

    private final String name;
    private final Byte value;

    public static String getName(Byte value) {
        return Arrays.stream(StaffWorkPropertyEnum.values())
                .filter(type -> Objects.equals(value, type.getValue()))
                .findFirst()
                .map(StaffWorkPropertyEnum::getName)
                .orElse(null);
    }

}
