package cn.smarthse.modules.health.enums.staff;

import cn.smarthse.common.util.StringUtils;

public enum StaffWorkChangeStatusRecordEnum {
	NOSTATUS_TO_NOSTATUS("无岗-->无岗",(byte)0,"00"),
	NOSTATUS_TO_ONWORKING("无岗-->在岗",(byte)1,"01"),
	NOSTATUS_TO_NOWORKED("无岗-->离岗",(byte)2,"02"),
	NOSTATUS_TO_FURLOUGH("无岗-->休假",(byte)3,"03"),
	
	ONWORKING_TO_NOWORKED("在岗-->离岗",(byte)4,"12"),
	ONWORKING_TO_FURLOUGH("在岗-->休假",(byte)5,"13"),
	
	NOWORKED_TO_ONWORKING("离岗-->在岗",(byte)6,"21"),
	NOWORKED_TO_FURLOUGH("离岗-->休假",(byte)7,"23"),
	
	FURLOUGH_TO_ONWORKING("休假-->在岗",(byte)8,"31"),
	FURLOUGH_TO_NOWORKED("休假-->离岗",(byte)9,"32"),
	;
	private StaffWorkChangeStatusRecordEnum(String name,Byte value,String flag){
		this.name=name;
		this.value=value;
		this.flag=flag;
	}
	
	private String name;
	
	private Byte value;
	
	/**
	 * 标识规律为StaffWorkStatusEnum中的属性value的值拼接而成的字符串
	 */
	private String flag;

	public String getName() {
		return name;
	}

	public Byte getValue() {
		return value;
	}

	public String getFlag() {
		return flag;
	}
	/**
	 * 
	 * @Comments:  <根据标识获取枚举>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年7月30日-上午8:47:54
	 * @param flag
	 * @return
	 */
	public static StaffWorkChangeStatusRecordEnum getThisEnumByFlag(String flag) {
		if(StringUtils.isNotEmpty(flag)) {
			StaffWorkChangeStatusRecordEnum[] all=StaffWorkChangeStatusRecordEnum.values();
			for(StaffWorkChangeStatusRecordEnum s:all) {
				if(s.getFlag().equals(flag.trim())) {
					return s;
				}
			}
		}
		return null;
	}
	
	/**
	 * 
	 * @Comments:  <根据系统中数据库中存在的值获取枚举>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年7月30日-上午8:50:36
	 * @param value
	 * @return
	 */
	public static StaffWorkChangeStatusRecordEnum getThisEnumByValue(Byte value) {
		if(value!=null) {
			StaffWorkChangeStatusRecordEnum[] all=StaffWorkChangeStatusRecordEnum.values();
			for(StaffWorkChangeStatusRecordEnum s:all) {
				if(s.getValue()==value) {
					return s;
				}
			}
		}
	    return null;
	}

}
