package cn.smarthse.modules.health.enums.staff;

/**
 * @ClassName StaffRadiationEnum
 * @Description 放射工作人员枚举
 * @Author 曾华川
 * @Date 2024年07月02日 17:50
 **/
public enum StaffRadiationEnum {
    IS_RADIATION(true, "是"),
    NO_RADIATION(false, "否"),
    ;

    private Boolean bool;
    private String name;

    public static String getRadiationStr(Boolean bool){
        if (bool != null){
            for (StaffRadiationEnum radiationEnum : values()) {
                if (radiationEnum.bool.equals(bool)){
                    return radiationEnum.name;
                }
            }
        }
        return "否";
    }

    StaffRadiationEnum(Boolean bool, String name) {
        this.bool = bool;
        this.name = name;
    }

    public Boolean getBool() {
        return bool;
    }

    public void setBool(Boolean bool) {
        this.bool = bool;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
