package cn.smarthse.modules.health.enums.staff;

import java.util.ArrayList;
import java.util.List;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <人员信息自定义列表头>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2018年1月18日-上午8:46:50
 */
public enum StaffListHeaderEnum {
	OTHERCOMPANY((byte)0,"外协企业名称",false,"otherCompany",true),
	REALNAME((byte)1,"姓名",true,"realName",null),
	SEX((byte)2,"性别",true,"sexName",null),
	IDCARD((byte)3,"身份证",false,"idCardNo",null),
	BIRTHDAY((byte)4,"出生日期",false,"birthday",null),
	AGE((byte)5,"年龄",false,"age",null),
	NATIVEPLACE((byte)6,"籍贯",false,"nativePlace",null),
	MARRIAGE((byte)7,"婚姻",false,"marriageName",null),
	NATION((byte)8,"民族",false,"nation",null),
	EDUCATION((byte)9,"学历",false,"educationName",null),
	MAJOR((byte)10,"专业",false,"major",null),
    PHONENO((byte)11,"手机号码",false,"phoneNo",null),
	EMAIL((byte)12,"邮箱",false,"email",null),
	JOINTIME((byte)13,"参加工作时间",false,"joinTime",null),
	WORKTIME((byte)14,"进厂时间",false,"workTime",null),
	WORKNO((byte)15,"工号",true,"workNo",null),
	JOBTITLE((byte)16,"职务",false,"jobTitle",null),
	ORGNAME((byte)17,"所属部门/车间",true,"orgName",null),
	WORK((byte)18,"岗位/工种",true,"workName",null),
	PLURALITY((byte)19,"兼职岗位",false,"plurality",null),
	WORKSTATUS((byte)20,"岗位状态",true,"workStatusName",null),
	ISRADIATION((byte)21,"放射工作人员",false,"isRadiationName",null),
	RADIATIONYEAR((byte)22,"起始从事放射工作时间",false,"radiationYear",null),
	RADIATIONTYPENAME((byte)23,"职业照射的职业分类及其代码",false,"radiationTypeName",null),
	SPECIALOPERATIONS((byte)24,"特种作业",false,"specialoperationsName",null),
	SPECIALWORK((byte)25,"特殊作业",false,"specialWorkName",null),
	FILENO((byte)26,"个人职业健康监护档案编号",false,"fileNo",null),
	FILINGTIME((byte)27,"建档时间",false,"filingTime",null),
	FILESSTORAGELOCATION((byte)28,"档案存放位置",false,"filesStorageLocation",null),
    INFORM((byte)29,"职业病危害合同告知记录",false,null,null),
    TRAIN((byte)30,"职业卫生教育培训记录",false,null,null),
    HEALTHCHECK((byte)31,"职业健康监护记录",false,null,null),
    WORKCHECKRESULT((byte)32,"岗位所接触的职业病危害因素检测结果",false,null,null),
	UPDATETIME((byte)33,"更新时间",true,"updateDate",null),
	OUTSOURCE((byte)34,"用工形式",false,"outsourceName",true),
	CURRENTWORKBEGINTIME((byte)35,"上岗时间",false,"currentWorkBeginTime",null),
	;
	
	private StaffListHeaderEnum(byte value,String headerName,Boolean isSelected,String propertyName,Boolean thirdParty) {
		this.value=value;
		this.headerName=headerName;
		this.isSelected=isSelected;
		this.propertyName=propertyName;
		this.thirdParty=thirdParty;
	}
	
	/**
	 * 导出对应的属性名(在StaffShowInfo的属性)
	 */
	private String propertyName;
	
	/**
	 * 列表头名
	 */
	private String headerName;
	
	/**
	 * 列表对应的值
	 */
	private Byte value;
	
	/**
	 * 默认是否选中
	 */
	private Boolean isSelected;
	
	
	/**
	 * 第三方特有的为true，null为共有的，false为本企业特有的
	 */
	private Boolean thirdParty;
	
//	public void setHeaderName(String headerName) {
//		this.headerName = headerName;
//	}
	public String getHeaderName() {
		return headerName;
	}
//	public void setValue(Byte value) {
//		this.value = value;
//	}
	
	public Byte getValue() {
		return value;
	}
	public Boolean getIsSelected() {
		return isSelected;
	}
//	public void setIsSelected(Boolean isSelected) {
//		this.isSelected = isSelected;
//	}
	
	public  static String getHeaderName(Byte headValue) {
		StaffListHeaderEnum[] list=StaffListHeaderEnum.values();
		for(StaffListHeaderEnum s:list) {
			if(s.getValue()==headValue) {
				return s.getHeaderName();
			}
		}
		return "";
	}
	
	public  static StaffListHeaderEnum getTHisEnumByHeadValue(Byte headValue) {
		StaffListHeaderEnum[] list=StaffListHeaderEnum.values();
		for(StaffListHeaderEnum s:list) {
			if(s.getValue()==headValue) {
				return s;
			}
		}
		return null;
	}
	
	/**
	 * 获取外包人员表头
	 * @return
	 */
	public static List<StaffListHeaderEnum> getThirdPartyEnumByHeadValues(){
		List<StaffListHeaderEnum> list=new ArrayList<StaffListHeaderEnum>();
		StaffListHeaderEnum[] array=StaffListHeaderEnum.values();
		
		for(StaffListHeaderEnum en:array) {
			 if(en.getThirdParty()==null||Boolean.TRUE.equals(en.getThirdParty())) {
				 list.add(en);
			 }
			
		}
		return list;
	}
	
	/**
	 * @return 获取本企业人员表头
	 */
	public static List<StaffListHeaderEnum> getNoThirdPartyEnumByHeadValues(){
		List<StaffListHeaderEnum> list=new ArrayList<StaffListHeaderEnum>();
		StaffListHeaderEnum[] array=StaffListHeaderEnum.values();
		
		for(StaffListHeaderEnum en:array) {
			 if(en.getThirdParty()==null||Boolean.FALSE.equals(en.getThirdParty())) {
				 list.add(en);
			 }
			
		}
		return list;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public Boolean getThirdParty() {
		return thirdParty;
	}

//	public void setThirdParty(Boolean thirdParty) {
//		this.thirdParty = thirdParty;
//	}

//	public void setPropertyName(String propertyName) {
//		this.propertyName = propertyName;
//	}

}
