package cn.smarthse.modules.health.enums.staff;

import cn.smarthse.common.util.StringUtils;

public enum StaffGenderEnum {
	
   MALE("男",1),FEMALE("女",0);
    private String name;
	
	private Integer value;
	
	private StaffGenderEnum(String name,Integer value){
		this.name=name;
		this.value=value;
	}

	public String getName() {
		return name;
	}


	public Integer getValue() {
		return value;
	}

	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return "";
		}
		for (StaffGenderEnum c : StaffGenderEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return "";
	}

	public static Integer getValue(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (StaffGenderEnum c : StaffGenderEnum.values()) {
			if (c.getName().equalsIgnoreCase(name)) {
				return c.value;
			}
		}
		return null;
	}

}
