package cn.smarthse.modules.health.enums.staff;

import java.util.Objects;

/**
 * @ClassName StaffFieldChangeEnum
 * @Description 人员字段变更枚举
 * @Author 曾华川
 * @Date 2024年06月27日 16:35
 **/
public enum StaffFieldChangeEnum {

    WORK_BEGIN_TIME(1, "本岗位上岗时间变更记录"),
    WORK_ROLE_STATUS(2, "岗位状态变更记录"),
    RADIATION_STAFF(3, "放射工作人员变更记录"),
    FIRST_WORK_BEGIN_TIME(4, "首次上岗时间变更记录"),
    JOB_NAME(5, "人员岗位变更记录"),
    STAFF_EXPORT(6, "人员导出记录"),
    ;

    private Integer code;
    private String name;

    static String getNameByCode(Integer code){
        if (code != null){
            for (StaffFieldChangeEnum changeEnum : values()) {
                if (Objects.equals(changeEnum.getCode(), code)){
                    return changeEnum.name;
                }
            }
        }
        return "";
    }

    StaffFieldChangeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
