package cn.smarthse.modules.health.enums.staff;

public enum StaffAddFromEnum {

    smarthse_staff_add("企业端人员新增", (byte) 1),

    /**
     * 省外适用
     */
    third_org_check_add("机构端体检导入新增", (byte) 2),

    @Deprecated
    smarthse_check_add("企业端体检导入新增", (byte) 3),

    /**
     * 数据太乱了
     */
    supervise_manager_or_single_add1("企业默认用户/企业单点用户新增", (byte) 4),
    supervise_manager_or_single_add2("企业默认用户/企业单点用户新增", (byte) 5),

    @Deprecated
    online_train_add("在线培训人员新增", (byte) 6),

    wanda_physical_import("万达仓体检新增", (byte) 9),

    un_known("老数据分不清的来源", (byte) 0);


    private final String name;
    private final Byte value;

    private StaffAddFromEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Byte getValue() {
        return value;
    }

    // 普通方法
    public static String getName(Byte value) {
        if (value == null) {
            return "";
        }
        for (StaffAddFromEnum c : StaffAddFromEnum.values()) {
            if (c.getValue() == value) {
                return c.name;
            }
        }
        return "";
    }

}
