package cn.smarthse.modules.health.enums.shield;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ShieldCycleUnitEnum {
	
	year("年","1"),	
	quarter("季","2"),	
	month("月","3"),
	week("周","4"),
	day("日","5"),
	; 
	
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private ShieldCycleUnitEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return "";
		}
		for (ShieldCycleUnitEnum c : ShieldCycleUnitEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return "";
	}
	public static String getCode(String name) {
		if (name == null) {
			return ShieldCycleUnitEnum.year.code;
		}
		for (ShieldCycleUnitEnum c : ShieldCycleUnitEnum.values()) {
			if (c.getName().equals(name)) {
				return c.code;
			}
		}
		return ShieldCycleUnitEnum.year.code;
	}
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
