package cn.smarthse.modules.health.enums.shield;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ShieldCountUnitEnum {
	//个、双、套、件、副、顶、条、只
	one("个","1"),	
	two("双","2"),	
	aset("套","3"),
	piece("件","4"),
	pairs("副","5"),
	ahat("顶","6"),	
	pair("条","7"),	
	a("只","8"),
	; 
	
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private ShieldCountUnitEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return ShieldCountUnitEnum.one.name;
		}
		for (ShieldCountUnitEnum c : ShieldCountUnitEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return ShieldCountUnitEnum.one.name;
	}
	// 普通方法
	public static String getCode(String name) {
		if (name == null) {
			return "";
		}
		for (ShieldCountUnitEnum c : ShieldCountUnitEnum.values()) {
			if (c.getName().equals(name)) {
				return c.code;
			}
		}
		return "";
	}


	public static String getCodeByName(String unitName) {
		if (unitName == null || unitName.length() == 0) {
			return null;
		}
		for (ShieldCountUnitEnum c : ShieldCountUnitEnum.values()) {
			if (c.getName().equals(unitName)) {
				return c.code;
			}
		}
		return null;
	}

	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
