package cn.smarthse.modules.health.enums.shield;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OxygenLackProtectEnum {
	
	protect1("配全面罩正压供气式呼吸防护用品，在佩戴携气式辅助逃生呼吸防护用品前提下使用","03020203"),	
	protect2("配送气头罩正压供气式呼吸防护用品，在佩戴携气式辅助逃生呼吸防护用品前提下使用","03020204"),	
	protect3("非爆炸环境时，配全面罩的正压携气式氧气呼吸器（爆炸环境时需选择空气呼吸器）","0305")
	; 
	
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private OxygenLackProtectEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (OxygenLackProtectEnum c : OxygenLackProtectEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}	
	public static List<String> getCodes() {
		List<String> codes = new ArrayList<String>();
		for (OxygenLackProtectEnum c : OxygenLackProtectEnum.values()) {
			codes.add(c.getCode());
		}
		return codes;
	}	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
