package cn.smarthse.modules.health.enums.servicedemand;

import java.util.Arrays;
import java.util.Optional;

public enum TrainTypeEnum {
    before(1,"上岗前劳动者培训"),
    between(2,"在岗期间劳动者培训"),
    main(3,"主要负责人培训"),
    manager(4,"职业卫生管理人员培训"),
    other(5,"其他培训"),
    is_null(-1,null);

    private TrainTypeEnum(Integer code, String name){
        this.name=name;
        this.code=code;
    }

    private String name;

    private Integer code;

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public static TrainTypeEnum getThisEnumByCode(Integer code){
        Optional<TrainTypeEnum> opt= Arrays.stream(TrainTypeEnum.values()).filter(s->{
            return s.getCode().equals(code);
        }).findFirst();
        return opt.isPresent()?opt.get():is_null;
    }
}
