package cn.smarthse.modules.health.enums.servicedemand;

import java.util.Arrays;
import java.util.Optional;

public enum ServiceDemandTypeEnum {
    check(1,"职业健康检查"),
    inspect(2,"职业病危害因素检测"),
    education(3,"教育培训"),
    evaluate(4,"评价工作"),
    is_null(-1,null);

    private ServiceDemandTypeEnum(Integer code, String name){
        this.name=name;
        this.code=code;
    }

    private String name;

    private Integer code;

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public static ServiceDemandTypeEnum getThisEnumByCode(Integer code){
        Optional<ServiceDemandTypeEnum> opt= Arrays.stream(ServiceDemandTypeEnum.values()).filter(s->{
            return s.getCode().equals(code);
        }).findFirst();
        return opt.isPresent()?opt.get():is_null;
    }
}
