package cn.smarthse.modules.health.enums.servicedemand;

import java.util.Arrays;
import java.util.Optional;

public enum  EvaluateTypeEnum {
    before(1,"预评"),
    controller(2,"控评"),
    now(3,"现状评价"),
    is_null(-1,null);

    private EvaluateTypeEnum(Integer code, String name){
        this.name=name;
        this.code=code;
    }

    private String name;

    private Integer code;

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public static EvaluateTypeEnum getThisEnumByCode(Integer code){
        Optional<EvaluateTypeEnum> opt= Arrays.stream(EvaluateTypeEnum.values()).filter(s->{
            return s.getCode().equals(code);
        }).findFirst();
        return opt.isPresent()?opt.get():is_null;
    }
}
