package cn.smarthse.modules.health.enums.servicedemand;

import java.util.Arrays;
import java.util.Optional;

public enum CheckTypeEnum {
    before(1,"上岗前"),
    between(2,"在岗期间"),
    leave(3,"离岗时"),
    now(4,"应急"),
    after(5,"离岗后"),
    is_null(-1,null);

    private CheckTypeEnum(Integer code, String name){
        this.name=name;
        this.code=code;
    }

    private String name;

    private Integer code;

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public static CheckTypeEnum getThisEnumByCode(Integer code){
        Optional<CheckTypeEnum> opt= Arrays.stream(CheckTypeEnum.values()).filter(s->{
            return s.getCode().equals(code);
        }).findFirst();
        return opt.isPresent()?opt.get():is_null;
    }
}
