package cn.smarthse.modules.health.enums.selfjudge;

import java.util.Arrays;

public enum SelfjudgeTermEnum {


    term1(1,"制度和操作规程",20),
    term2(2,"管理机构和人员",10),
    term3(3,"职业卫生档案",20),
    term4(4,"职业病危害申报",null),
    term5(5,"职业病防护设施“三同时”",10),
    term6(6,"职业病危害因素浓度或强度",20),
    term7(7,"有害和无害作业分开；工作场所与生活场所分开",10),
    term8(8,"定期检测",null),
    term9(9,"现状评价",10),
    term10(10,"治理措施",10),
    term11(11,"防护设施配备",10),
    term12(12,"防护用品配备",10),
    term13(13,"合同告知",null),
    term14(14,"公告栏、警示标识和告知卡",10),
    term15(15,"主要负责人和职业卫生管理人员培训",10),
    term16(16,"劳动者培训",null),
    term17(17,"职业健康检查",null),
    term18(18,"体检结果处置和告知",null),
    term19(19,"应急救援预案与演练",10),
    term20(20,"发生职业病病例或行政处罚",null);

    private Integer code;
    private String name;
    private Integer score;




    private SelfjudgeTermEnum(Integer code, String name,Integer score) {
        this.code = code;
        this.name = name;
        this.score=score;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public Integer getScore() {
        return score;
    }
    public static SelfjudgeTermEnum getThisEnumByCode(Integer code){
        return  Arrays.stream(SelfjudgeTermEnum.values()).filter(s->s.getCode().equals(code)).findFirst().orElse(null);
    }
}
