package cn.smarthse.modules.health.enums.selfjudge;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public enum JudgeResultLevelEnum {

    A(1,"A",90L,100L),
    B(2,"B",70L,90L),
    C(3,"C",0L,70L);

    private JudgeResultLevelEnum(Integer code,String name,Long minScore,Long maxScore ){
        this.code=code;
        this.name=name;
        this.minScore=minScore;
        this.maxScore=maxScore;
    }


    private  Integer code;

    private String name;

    private Long minScore;

    private Long maxScore;

    public static JudgeResultLevelEnum getThisEnumByScore(Double score){
        if(score==null){
          return C;
        }else if(A.minScore<=score&&score<=A.maxScore){
            return A;
        }else if(B.minScore<=score&&score<B.maxScore){
             return B;
        }else {
            return C;
        }

    }

    public static JudgeResultLevelEnum getThisEnumByCode(Integer code){
        return  Arrays.stream(JudgeResultLevelEnum.values()).filter(s->s.getCode().equals(code)).findFirst().orElse(C);
    }
    public static String getNameByCode(Integer code){
        Optional<JudgeResultLevelEnum> judgeResultLevelEnum = Arrays.stream(JudgeResultLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (judgeResultLevelEnum.isPresent()) {
            return judgeResultLevelEnum.get().getName();
        }
        return  "未评定";
    }


    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public Long getMinScore() {
        return minScore;
    }

    public Long getMaxScore() {
        return maxScore;
    }
}
