package cn.smarthse.modules.health.enums.selfjudge;

import java.util.Arrays;
import java.util.Optional;

/*
* @Comments:  <职业病危害综合风险类别>
* @author BinXu(徐斌) [784514607@qq.com]
* @since 上午9:01 2021/12/8
**/
public enum HazardsRiskClassifyEnum {
    first(1,"甲类"),
    second(2,"乙类"),
    third(3,"丙类");

    HazardsRiskClassifyEnum(Integer code, String name){
          this.code=code;
          this.name=name;
    }

    private Integer code;

    private  String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public    static HazardsRiskClassifyEnum getThisEnumByJudgeLevelAndRiskLevel(JudgeResultLevelEnum judgeLevel, HazardsExposureRiskLevelEnum riskLevel){
        if(judgeLevel!=null&&riskLevel!=null){
            if(JudgeResultLevelEnum.A.equals(judgeLevel)){
                if(HazardsExposureRiskLevelEnum.heightRisk.equals(riskLevel)){
                    return  second;
                }else {
                    return  first;
                }
            }else if(JudgeResultLevelEnum.B.equals(judgeLevel)){
                if(HazardsExposureRiskLevelEnum.lowRisk.equals(riskLevel)){
                    return  first;
                }else if(HazardsExposureRiskLevelEnum.middleRisk.equals(riskLevel)){
                    return  second;
                }else if(HazardsExposureRiskLevelEnum.heightRisk.equals(riskLevel)){
                    return  third;
                }
            }else if(JudgeResultLevelEnum.C.equals(judgeLevel)){
                if(HazardsExposureRiskLevelEnum.lowRisk.equals(riskLevel)){
                    return  second;
                }else {
                    return  third;
                }
            }

        }
        return null;
    }

    public static HazardsRiskClassifyEnum getThisEnumByCode(Integer code){
        return  Arrays.stream(HazardsRiskClassifyEnum.values()).filter(s->s.getCode().equals(code)).findFirst().orElse(null);
    }

    public static String getNameByCode(Integer code){
        Optional<HazardsRiskClassifyEnum> judgeResultLevelEnum = Arrays.stream(HazardsRiskClassifyEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (judgeResultLevelEnum.isPresent()) {
            return judgeResultLevelEnum.get().getName();
        }
        return  "";
    }



}
