package cn.smarthse.modules.health.enums.selfjudge;

import java.util.Arrays;
import java.util.Optional;

/*
* @Comments:  <职业病危害暴露风险等级>
* @author BinXu(徐斌) [784514607@qq.com]
* @since 上午9:01 2021/12/8
**/
public enum HazardsExposureRiskLevelEnum {
    lowRisk(1,"Ⅰ级"),
    middleRisk(2,"Ⅱ级"),
    heightRisk(3,"Ⅲ级");
    //1：低风险（Ⅰ级），2：中风险（Ⅱ级），3：高风险（Ⅲ级）
    HazardsExposureRiskLevelEnum(Integer code, String name){
          this.code=code;
          this.name=name;
    }

    private Integer code;

    private  String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private   static HazardsExposureRiskLevelEnum getThisEnumByStandardEnumAndStaffCount(HarmNatureStandardEnum standard,int staffCount){
        if(standard!=null){
           if(HarmNatureStandardEnum.generalNotOver.equals(standard)){
              return lowRisk;
           }else if(HarmNatureStandardEnum.generalOver.equals(standard)){
              if(staffCount<=9){
               return  lowRisk;
               // 风险bug修复： 小于10的数据已经进入上一个if了
              }else if(staffCount<=49){
               return middleRisk;
              }else {
               return heightRisk;
              }
           }else if(HarmNatureStandardEnum.seriousNotOver.equals(standard)){
               if(staffCount<=0) {
                   return lowRisk;
               }else if(staffCount<=49){
                 return middleRisk;
               }else {
                  return heightRisk;
               }
           }else if(HarmNatureStandardEnum.seriousOver.equals(standard)){
               if(staffCount<=9){
                return middleRisk;
               }else {
                 return heightRisk;
               }
           }
        }
        return null;
    }

    /* 
    * @Comments:  <职业病危害暴露风险等级判断规则一般职业病危害因素和严重职业病危害因素同时存在时，依风险分类高者判别>
    * generalOverStaffCount  一般职业病危害因素超标人数  generalTotalStaffCount 一般职业病危害因素总人数
    *  seriousOverStaffCount  严重职业病危害因素超标人数 seriousOverTotalStaffCount 严重职业病危害因素总人数
    **/
    public  static HazardsExposureRiskLevelEnum  getFinalThisEnumByStaffCount(int generalOverStaffCount,int generalTotalStaffCount,
                                                                              int seriousOverStaffCount,int seriousOverTotalStaffCount){
      HarmNatureStandardEnum general=HarmNatureStandardEnum.getThisGeneralEnumByStaffCount(generalOverStaffCount);
      HarmNatureStandardEnum serious=HarmNatureStandardEnum.getThisSeriousEnumByStaffCount(seriousOverStaffCount);
      HazardsExposureRiskLevelEnum generalLevel=getThisEnumByStandardEnumAndStaffCount(general,generalTotalStaffCount);
      HazardsExposureRiskLevelEnum seriousLevel=getThisEnumByStandardEnumAndStaffCount(serious,seriousOverTotalStaffCount);
      if(generalLevel==null&&seriousLevel==null){
         return null;
      }else {
       if(generalLevel==null&&seriousLevel!=null) {
            return seriousLevel;
      }else if(generalLevel!=null&&seriousLevel==null){
            return generalLevel;
      }else {
            Integer code= generalLevel.getCode();
        return  code>seriousLevel.getCode()?generalLevel:seriousLevel;
      }
      }

    }

    public static HazardsExposureRiskLevelEnum getThisEnumByCode(Integer code){
        return  Arrays.stream(HazardsExposureRiskLevelEnum.values()).filter(s->s.getCode().equals(code)).findFirst().orElse(null);
    }

    public static String getNameByCode(Integer code){
        Optional<HazardsExposureRiskLevelEnum> judgeResultLevelEnum = Arrays.stream(HazardsExposureRiskLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (judgeResultLevelEnum.isPresent()) {
            return judgeResultLevelEnum.get().getName();
        }
        return  "未评定";
    }


}
