package cn.smarthse.modules.health.enums.selfjudge;

import cn.smarthse.common.util.StringUtils;

import java.util.Arrays;

public enum CheckResultEnum {

    result1(1,"符合"),
    result2(2,"基本符合"),
    result3(3,"不符合"),
    result4(4,"合理缺项");

    private CheckResultEnum(Integer code, String name){
        this.code=code;
        this.name=name;
    }


    private  Integer code;

    private String name;




    public static CheckResultEnum getThisEnumByCode(Integer code){
        return  Arrays.stream(CheckResultEnum.values()).filter(s->s.getCode().equals(code)).findFirst().orElse(null);
    }
    public static CheckResultEnum getThisEnumByName(String name){
        if(StringUtils.isEmpty(name)){
          return result1;
        }
        return  Arrays.stream(CheckResultEnum.values()).filter(s->s.getName().equals(name.trim())).findFirst().orElse(result1);
    }


    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
