package cn.smarthse.modules.health.enums.scene;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 检查类型：综合性检查、专项检查、上级监督检查-职业卫生、上级监督检查-安全、日常检查、事故类比检查、重大危险源检查、节假日前后检查、季节性检查、中介机构检查、其他类检查，部分value和表scene_inspection_table_features对应
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年9月4日-下午3:59:07
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InspectionTypeEnum {

	
	/**
	 * 综合性检查
	 */
	comprehensive("综合性检查",(byte)6),
	
	/**
	 * 专项检查
	 */
	professional("专项检查",(byte)7),
	
//	/**
//	 * 上级监督检查-职业卫生
//	 */
//	superiorsInspectHse("上级监督检查-职业卫生",(byte)14),
//	
//	/**
//	 * 上级监督检查-安全
//	 */
//	superiorsInspectSafe("上级监督检查-安全",(byte)15),
	
	/**
	 * 上级监督检查
	 */
	superiorsInspect("上级监督检查",(byte)17),
	/**
	 * 监管端添加 的 上级监督检查（集团版）
	 */
	superviseSuperiorsInspect("上级监督检查",(byte)18),

	/**
	 * 日常检查
	 */
	dailyInspection("日常检查",(byte) 5),

	/**
	 * 事故类比检查
	 */
	accidentAnalogy("事故类比检查",(byte)16),
	
	/**
	 * 重大危险源检查
	 */
	majorHazard("重大危险源检查",(byte)8),
	
	/**
	 * 节假日前后检查
	 */
	holidayAround("节假日前后检查",(byte)9),
	
	/**
	 * 季节性检查
	 */
	seasonality("季节性检查",(byte)10),
	
	/**
	 * 中介机构检查
	 */
	agency("中介机构检查",(byte)12),
	
	/**
	 * 其他类检查
	 */
	other("其他类检查",(byte)13),
	
	;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private InspectionTypeEnum(String name, byte value) {
			this.name = name;
			this.value = value;
		}
		
		public static String getNameByValue(Byte value){

			if(value==null){
				return "";
			}
			for(InspectionTypeEnum type : InspectionTypeEnum.values()){
				if(type.getValue().equals(value)){
					return type.getName();
				}
			}
			return "";
		
		}
		
		/**
		 * 是否上级监督检查
		 * @param type
		 * @return
		 */
		public static boolean isSuperiorsType(Byte type){
			if(type == null){
				return false;
			}
			if(
//					type.equals(InspectionTypeEnum.superiorsInspectHse.getValue()) 
//					|| type.equals(InspectionTypeEnum.superiorsInspectSafe.getValue())
//					|| 
					type.equals(InspectionTypeEnum.superiorsInspect.getValue())){
				return true;
			}
			return false;
		}
		
		/**
		 * 获取检查类型的byte
		 * 
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author Horsy(何世壹) [hsy@smarthse.cn]
		 * @since 2018年1月2日-上午10:44:34
		 * @param typeStr
		 * @return
		 */
		public static Byte getTypeByString(String typeStr){
			if(StringUtils.isEmpty(typeStr)){
				return null;
			}
			for(InspectionTypeEnum type : InspectionTypeEnum.values()){
				if((type.getValue()+"").equals(typeStr)){
					return type.getValue();
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}
