package cn.smarthse.modules.health.enums.scene;


import com.fasterxml.jackson.annotation.JsonFormat;

import cn.smarthse.common.util.StringUtils;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InspectionTableTypeEnum {


	/**
	 * 职业健康
	 */
	occupationalHelath("职业卫生",(byte) 1),
	/**
	 * 安全
	 */
	security("安全",(byte) 2),
	/**
	 * 环保
	 */
	environmentalProtection("环保",(byte) 3),
	
	;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private InspectionTableTypeEnum(String name, byte value) {
			this.name = name;
			this.value = value;
		}
		
		public static String getNameByValue(Byte value){
			if(value==null){
				return "";
			}
			for(InspectionTableTypeEnum type : InspectionTableTypeEnum.values()){
				if(type.getValue().equals(value)){
					return type.getName();
				}
			}
			return "";
		}
		
		public static Byte getValueByValueStr(String valueStr){
			if(!StringUtils.isBlank(valueStr)){
				for(InspectionTableTypeEnum type : InspectionTableTypeEnum.values()){
					if((type.getValue()+"").equals(valueStr)){
						return type.getValue();
					}
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}
