package cn.smarthse.modules.health.enums.scene;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 检查表类型（内部类型）
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月17日-下午1:54:21
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InspectionTableNativeCodeEnum {


	/**
	 *自定义检查表
	 */
	custom("自定义检查表",(byte) 0,"customTableTemplate.xls"),
	/**
	 * 应急物质
	 */
	emergencyMaterial("应急物质",(byte) 1,"materialTemplate.xls"),
	
	/**
	 * 设备设施
	 */
	device("设备设施",(byte) 2,"equipmentTemplate.xls"),
	

	/**
	 * 警示标识
	 */
	warningSigns("警示标识",(byte) 3,"warningSingTemplate.xls"),
	

	/**
	 * 整改项
	 */
	reformItem("整改项",(byte) 4,"reformItemTemplate.xls"),
	
	;
	
		// 成员变量
		private String name;
		private Byte value;
		
		private String exportTemplateFileName;
		// 构造方法
		
		private InspectionTableNativeCodeEnum(String name, Byte value,String exportTemplateFileName) {
			this.name = name;
			this.value = value;
			this.exportTemplateFileName=exportTemplateFileName;
		}
		
		/**
		 * 获取系统自带检查表类型
		 * @return
		 */
		public static List<Byte> getSystemBringType(){
			List<Byte> list=new ArrayList<Byte>();
			list.add(emergencyMaterial.getValue());
			list.add(device.getValue());
			list.add(warningSigns.getValue());
			list.add(reformItem.getValue());
			return list;
		}
		
		public static String getTemplateFileName(Byte index){
			for (InspectionTableNativeCodeEnum c : InspectionTableNativeCodeEnum.values()) {
				if (c.getValue().equals(index)) {
					return c.getExportTemplateFileName();
				}
			}
			return null;
		}
		
		public static String getTypeName(Byte index){
			if(index == null){
				return null;
			}
			for (InspectionTableNativeCodeEnum c : InspectionTableNativeCodeEnum.values()) {
				if (c.getValue().equals(index)) {
					return c.getName();
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}

		public String getExportTemplateFileName() {
			return exportTemplateFileName;
		}

		public void setExportTemplateFileName(String exportTemplateFileName) {
			this.exportTemplateFileName = exportTemplateFileName;
		}
		

}
