package cn.smarthse.modules.health.enums.scene;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 检查结果
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年9月4日-下午3:59:07
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InspectionResultEnum {

	
	/**
	 *无隐患/已完成
	 */
	noHiddenDenger("无隐患",(byte)0),
	
	/**
	 * 有隐患/未完成
	 */
	hasHiddenDanger("有隐患",(byte)1),
	
	
	;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private InspectionResultEnum(String name, byte value) {
			this.name = name;
			this.value = value;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}
