package cn.smarthse.modules.health.enums.scene;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InspectionObjectEnum {

	/**
	 * 检查类型1
	 */
	inspectionType1("现场检查类型1",new InspectionTableTypeEnum[] {
			InspectionTableTypeEnum.occupationalHelath,
			InspectionTableTypeEnum.security
	}),
	
	/**
	 * 所有检测类型
	 */
	inspectionTypeAll("所有检测类型",new InspectionTypeEnum[]{
			InspectionTypeEnum.comprehensive,
			InspectionTypeEnum.professional,
			InspectionTypeEnum.dailyInspection,
			InspectionTypeEnum.accidentAnalogy,
			InspectionTypeEnum.majorHazard,
			InspectionTypeEnum.holidayAround,
			InspectionTypeEnum.seasonality,
			InspectionTypeEnum.agency,
//			InspectionTypeEnum.superiorsInspectHse,
//			InspectionTypeEnum.superiorsInspectSafe,
			InspectionTypeEnum.other,
	}),
	
	/**
	 * 检查类型2
	 */
	inspectionType2("现场检查类型2",new InspectionTypeEnum[]{
			InspectionTypeEnum.comprehensive,
			InspectionTypeEnum.professional,
			InspectionTypeEnum.dailyInspection,
			InspectionTypeEnum.accidentAnalogy,
			InspectionTypeEnum.majorHazard,
			InspectionTypeEnum.holidayAround,
			InspectionTypeEnum.seasonality,
			InspectionTypeEnum.agency,
			InspectionTypeEnum.other,
	}),
	/**
	 * 检查类型，上级监督检查
	 */
	inspectionTypeSuper("上级监督检查",new InspectionTypeEnum[]{
//			InspectionTypeEnum.superiorsInspectHse,
//			InspectionTypeEnum.superiorsInspectSafe,
			InspectionTypeEnum.superiorsInspect,
	}),
	
	/**
	 * 上级监督检查，不要安全。
	 */
//	inspectionTypeSuperNoSafe("上级监督检查",new InspectionTypeEnum[]{
//			InspectionTypeEnum.superiorsInspectHse,
//			InspectionTypeEnum.superiorsInspect,
//	}),
	;
	
		// 成员变量
		private String name;
		private Object[] value;
		// 构造方法
		
		private InspectionObjectEnum(String name, Object[] value) {
			this.name = name;
			this.value = value;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Object[] getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Object[] value) {
			this.value = value;
		}
		

}
