package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 整改项生成来源
 *
 * @author xiaoyi
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2021年12月14日-下午3:53:14
 */
@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformStatusEnum {

    /**
     * 存草稿（未确认）
     */
    CG("草稿", (byte) 0),

    /**
     * 待整改（信息已确认）
     */
    DZG("待整改", (byte) 1),// 职业健康在线V3.2.2监管和企业页面显示是把退回也算成待整改的，草稿状态也算为待整改，库里还是实际存的0草稿，5退回

    /**
     * 已整改（待验收）
     */
    DYS("待验收", (byte) 2),

    /**
     * 完成（验收通过）
     */
    WC("已完成", (byte) 3),

    /**
     * 无需整改
     */
    WXZG("无需整改", (byte) 4),// 职业健康在线V3.2.2删除了该类型

    /**
     * 退回
     */
    TH("退回", (byte) 5),

    /**
     * 监管忽略
     */
    JGHL("监管忽略", (byte) 6),// 系统老的已经没用了

    /**
     * 中止
     */
    ZZ("中止", (byte) 10),

    QDZF("启动执法", (byte) 9);

    private final String name;
    private final Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformStatusEnum level : ReformStatusEnum.values()) {
            if (level.getValue().equals(value)) {
                return level.getName();
            }
        }
        return null;
    }

    public static ReformStatusEnum getEnum(Byte value) {
        return Arrays.stream(ReformStatusEnum.values())
                .filter(t -> Objects.equals(t.getValue(), value))
                .findFirst()
                .orElse(null);
    }
}

