package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 隐患来源（职业健康在线V3.2.2更新）：
 *
 *  主体履责1 ==> 防治责任自查 1
 *  服务管家2 ==> 第三方托管核查 2
 *  智能评估3 ==> 职业健康体检、职业病危害因素检测  3，4
 *  乡镇协管4 ==> 乡镇协管 7
 *  在线监测监控5 ==> 在线监测、在线监控 5，6
 * @since 2023/07/05 by liaoly 拓展服务管家-9 类型
 *
 * @author zhangxu
 * @date 2023-03-16
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformSourceLiteEnum {

    FZZRZC("防治责任自查", (byte) 1),
    DSFTG("第三方托管核查", (byte) 2),
    ZYJKTJ("职业健康体检", (byte) 3),
    ZYBWHYSJC("职业病危害因素检测", (byte) 4),
    ZXJC("在线监测", (byte) 5),//2024.8.5废弃了
    ZXJK("在线监控", (byte) 6),//2024.8.5废弃了
    ZXJCJK("在线监测监控", (byte) 56),
    TOWNSHIP_MANAGE("乡镇协管", (byte) 7),
    KEY_FACTOR_PORTRAIT("关键因素画像", (byte) 8),
    FWGJ("服务管家", (byte) 9),
    ;

    private String name;
    private Byte value;

    public static String getSourceNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformSourceLiteEnum source : ReformSourceLiteEnum.values()) {
            if (value.equals(source.getValue())) {
                return source.getName();
            }
        }
        return null;
    }
}

