package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.smarthse.common.framework.enums.BusinessTypeEnum;

/**
 * 
 * 隐患来源，注意：增加来源之后，需在相应实体类的数据验证注解里面修改相应的信息
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月9日-下午3:53:14
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformSourceEnum {


		/**
		 * 隐患排查
		 */
		sceneInspection("隐患排查",(byte) 1,BusinessTypeEnum.sceneInspection),
		/**
		 * 上级督察
		 */
		supervise("上级督查",(byte) 2,BusinessTypeEnum.sceneInspection),
		/**
		 * 职业病危害因素检测
		 */
		harmFactorInspection("职业病危害因素检测",(byte) 3,BusinessTypeEnum.hccheckplan),
		
		/**
		 * 应急演练
		 */
		emeDrill("应急演练",(byte) 4,BusinessTypeEnum.emeDrills),
		
		/**
		 * 持续改进
		 */
		continuousImprovement("持续改进",(byte) 5,null),
		
		/**
		 * 评价管理
		 */
		evaluationManage("职业卫生评价",(byte) 6,null),

		/**
		 * 事故处理
		 */
		physicalCheck("职业健康体检",(byte)9,null),
		
		/**
		 * 事故处理
		 */
		accidentTreatment("事故处理",(byte)7,null),

		/**
		 *
		 */
		onlineMonitor("在线监测",(byte)8,null),


	onlineVideo("在线监控",(byte)11,null),

		/**
		 * 分类自查
		 */
		selfInspection("分类自查",(byte)10,null),
		
		;
	
		// 成员变量
		private String name;
		private Byte value;
		private BusinessTypeEnum businessType;
		// 构造方法
		
		private ReformSourceEnum(String name, Byte value,BusinessTypeEnum businessType) {
			this.name = name;
			this.value = value;
			this.businessType = businessType;
		}
		/**
		 * 根据整改来源ID，获取模块枚举
		 * 
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author Horsy(何世壹) [hsy@smarthse.cn]
		 * @since 2017年10月24日-上午11:13:04
		 * @param value
		 * @return
		 */
		public static BusinessTypeEnum getBusinessTypeByValue(Byte value){
			if( value == null){
				return null;
			}
			for(ReformSourceEnum source:ReformSourceEnum.values()){
				if(value.equals(source.getValue())){
					return source.getBusinessType();
				}
			}
			return null;
		}
		public static String getSourceNameByValue(Byte value){
			if( value == null){
				return null;
			}
			for(ReformSourceEnum source:ReformSourceEnum.values()){
				if(value.equals(source.getValue())){
					return source.getName();
				}
			}
			return null;
		}
		
		public BusinessTypeEnum getBusinessType() {
			return businessType;
		}

		public void setBusinessType(BusinessTypeEnum businessType) {
			this.businessType = businessType;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}
		
		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}

