package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险化解-示警状态枚举
 * @author 覃浩云 1770126791@qq.com
 * @date 2023/5/15 13:51
 */
@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformResolveStatusEnum {

    /**
     * 已化解风险
     */
    RESOLVED("已化解", (byte) 0),

    /**
     * 首次推送
     */
    FIRSTPUSH("首次推送", (byte) 1),

    /**
     * 黄色预警
     */
    YELLOWWARN("黄色预警", (byte) 2),

    /**
     * 红色预警
     */
    REDWARN("红色预警", (byte) 3),

    /**
     * 启动执法
     */
    STARTPUNISH("启动执法", (byte) 4);

    private final String name;
    private final Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformResolveStatusEnum level : ReformResolveStatusEnum.values()) {
            if (level.getValue().equals(value)) {
                return level.getName();
            }
        }
        return null;
    }

    public static ReformResolveStatusEnum getByType(Byte type) {
        for (ReformResolveStatusEnum scoreEnum : ReformResolveStatusEnum.values()) {
            if (scoreEnum.getValue().equals(type)) {
                return scoreEnum;
            }
        }
        return null;
    }

}

