package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 隐患分类
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月9日-上午10:24:31
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformItemTypeEnum {


		/**
		 * 管理类
		 */
		manage("管理类",(byte) 1),
		
		/**
		 * 从业人员类
		 */
		employees("从业人员类",(byte) 2),
		
		/**
		 * 设备设施及物料类
		 */
		deviceAndMateriel("设备设施及物料类",(byte) 3),
		
		/**
		 * 场所环境类
		 */
		workPlace("场所环境类",(byte) 4),
		
		;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private ReformItemTypeEnum(String name, byte value) {
			this.name = name;
			this.value = value;
		}
	public static String getTypeNameByValue(Byte value){
		if( value == null){
			return null;
		}
		for(ReformItemTypeEnum source:ReformItemTypeEnum.values()){
			if(value.equals(source.getValue())){
				return source.getName();
			}
		}
		return null;
	}
		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}

