package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 隐患等级
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月9日-上午10:24:31
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformItemLevelEnum {


		/**
		 * 一般事故隐患现场立即整改
		 */
		generalScene("一般事故隐患现场立即整改",(byte) 1),
		/**
		 * 一般事故隐患限期整改
		 */
		generalTimeLimit("一般事故隐患限期整改",(byte) 2),
		/**
		 * 重大事故隐患停产停业整顿
		 */
		majorStop("重大事故隐患停产停业整顿",(byte) 3),
		
		;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private ReformItemLevelEnum(String name, Byte value) {
			this.name = name;
			this.value = value;
		}
		
		public static String getNameByValue(Byte value){
			if(value== null){
				return null;
			}
			for(ReformItemLevelEnum level:ReformItemLevelEnum.values()){
				if(level.getValue().equals(value)){
					return level.getName();
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}

