package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 隐患等级
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月9日-上午10:24:31
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformItemHarmFactorStatusEnum {


		/**
		 * 忽略
		 */
		ignore("忽略",(byte) 0),
		/**
		 * 正常
		 */
		normal("正常",(byte) 1),
		
		/**
		 * 复测(已经复测过)
		 */
		retest("复测",(byte)2),
		;
	
		// 成员变量
		private String name;
		private Byte value;
		// 构造方法
		
		private ReformItemHarmFactorStatusEnum(String name, Byte value) {
			this.name = name;
			this.value = value;
		}
		
		public static ReformItemHarmFactorStatusEnum getByValue(Byte value){
			if(value == null){
				return null;
			}
			for(ReformItemHarmFactorStatusEnum status : ReformItemHarmFactorStatusEnum.values()){
				if(status.getValue().equals(value)){
					return status;
				}
			}
			return null;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public Byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(Byte value) {
			this.value = value;
		}
		

}

