package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 生成的整改项类型 3.2.2.1 最新标准
 * 新的整改项8+3 申报 三同时 检测 个人防护 警示标识 负责人培训 体检 档案 存在检测超标 存在疑似职业病患者 存在职业禁忌证者
 *
 * @author xiaoyi
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @date 2023-04-25
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformGenerationSourceEnum {

    OTHER("其他",(byte) 0),
    // 3.2.2.1最新标准在用
    //关键画像这边在用
    JCCB("存在检测超标", (byte) 3),
    JJZ("存在职业禁忌证者", (byte) 4),
    YSZYB("存在疑似职业病患者", (byte) 5),
    /**
     * 体检包含4567内容
     */
    TJ("体检", (byte) 10),
    DECLARE("申报", (byte) 12),
    THREE_TIME("三同时", (byte) 13),
    DETECTION("检测", (byte) 14),//乡镇协管，没有检测，生成的整改项,
    PROTECTION("个人防护", (byte) 15),
    WARNING_SIGNS ("警示标识", (byte) 16),
    TRAIN("负责人培训", (byte) 17),
    ARCHIVES("档案", (byte) 18),

    //以下好像没用了
    ZRZC("责任自查", (byte) 1),
    SFTG("第三方托管", (byte) 2),
    FC("复查", (byte) 6),
    ZYB("诊断-职业病", (byte) 7),
    ZXJC("在线监测", (byte) 8),//2024.8.5以后应该都是废弃的不用
    ZXJK("在线监控", (byte) 9),//2024.8.5以后应该都是废弃的不用
    ZXJCJK("在线监测监控", (byte) 89),//2024.8.5以后应该都是废弃的不用
    XZXG("乡镇协管", (byte) 11),

    //V3222版本 新增培训类型
    NOZYFZR("主要负责人无数据", (byte) 19),
    NOGLRY("管理人员无数据", (byte) 20),

    // 2024年03月01日推送风险，新增监测超标整改风险项
    JCCBZG("监测超标整改", (byte) 21),//2024.8.5在线监测部分全部用的是这个，有两个子项，

    //2024-02-28 新增3个风险类型 //服务管家这边在用，是分开的两个
    type_30("检测结果超标", (byte) 30),
    type_40("职业禁忌证调岗不符合要求", (byte) 40),
    type_50("职业病的报告和诊断", (byte) 50),

    DETECTION_ITEM2("定期检测",(byte) 22),
    DETECTION_ITEM3("现状评价",(byte) 23),
    ;



    private String name;
    private Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformGenerationSourceEnum level : ReformGenerationSourceEnum.values()) {
            if (level.getValue().equals(value)) {
                return level.getName();
            }
        }
        return null;
    }

    public static ReformGenerationSourceEnum getByType(Byte type) {
        for (ReformGenerationSourceEnum reformGenerationSourceEnum : ReformGenerationSourceEnum.values()) {
            if (reformGenerationSourceEnum.getValue().equals(type)) {
                return reformGenerationSourceEnum;
            }
        }
        return null;
    }

    /**
     * 共 8 类（培训多NOZYFZR、NOGLRY两种）数量不能动，动了关键因素画像的生成要出问题
     *
     * @return
     */
    public static List<Byte> getEightGenerationSourceValue() {
        return Arrays.asList(
                TJ.getValue(),
                DECLARE.getValue(),
                THREE_TIME.getValue(),
                DETECTION.getValue(),
                PROTECTION.getValue(),
                WARNING_SIGNS.getValue(),
                TRAIN.getValue(),
                ARCHIVES.getValue(),
                NOZYFZR.getValue(),
                NOGLRY.getValue()
        );
    }
}

