package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 生成的整改项类型generationSource的子项
 * @author zhangxu
 * @date 2024-08-05
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformGenerationSourceChildEnum {

    JZ_JCB("在线监测--存在检测超标", (byte) 1),
    JZ_YFSG("在线监测--超标且引发事故", (byte) 2),
    ;



    private String name;
    private Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformGenerationSourceChildEnum level : ReformGenerationSourceChildEnum.values()) {
            if (level.getValue().equals(value)) {
                return level.getName();
            }
        }
        return null;
    }

    public static ReformGenerationSourceChildEnum getByType(Byte type) {
        for (ReformGenerationSourceChildEnum reformGenerationSourceEnum : ReformGenerationSourceChildEnum.values()) {
            if (reformGenerationSourceEnum.getValue().equals(type)) {
                return reformGenerationSourceEnum;
            }
        }
        return null;
    }
}

