package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;


/**
 * 风险数据来源（外来来源，目前基本没啥意义，除了新建企业）
 *
 * @author zhangxu
 * @date 2024-07-30
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformDataSourceEnum {
    WU("无分类", (byte) 0),
    WDC("万达仓", (byte) 1),
    KEYFACTORY("关键因素画像", (byte) 2),
    YSXC("疑似巡查那边的", (byte) 3),
    XJQY("新建企业风险", (byte) 5),
    BX("标玺", (byte) 10),
    ;

    private String name;
    private Byte value;

    public static String getSourceNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (ReformDataSourceEnum source : ReformDataSourceEnum.values()) {
            if (value.equals(source.getValue())) {
                return source.getName();
            }
        }
        return null;
    }

    public static ReformDataSourceEnum getEnum(Byte value) {
        return Arrays.stream(ReformDataSourceEnum.values())
                .filter(t -> Objects.equals(t.getValue(), value))
                .findFirst()
                .orElse(null);
    }
}

