package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 整改及验收记录状态枚举类
 *
 * @author zhangxu
 * @date 2023-03-13
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ReformAcceptanceRecordStatusEnum {

    CG("草稿",(byte)0),
    DSH("待审核",(byte)1),
    WXZG("无需整改",(byte)2),
    WC("完成",(byte)3),
    ;

    // 成员变量
    private String name;
    private Byte value;
    // 构造方法



    private ReformAcceptanceRecordStatusEnum(String name, Byte value) {
        this.name = name;
        this.value = value;
    }

    public static String getNameByValue(Byte value){
        if( value == null){
            return null;
        }
        for(ReformAcceptanceRecordStatusEnum status: ReformAcceptanceRecordStatusEnum.values()){
            if(value.equals(status.getValue())){
                return status.getName();
            }
        }
        return null;
    }



    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the value
     */
    public Byte getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    public void setValue(Byte value) {
        this.value = value;
    }


}
