package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 生成的整改项类型 3.2.2.1 最新标准
 * 新的整改项8+3 申报 三同时 检测 个人防护 警示标识 负责人培训 体检 档案 存在检测超标 存在疑似职业病患者 存在职业禁忌证者
 *
 * @author xiaoyi
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @date 2023-04-25
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PushRiskContentEnum {

    TJ("未按照规定组织职业健康检查；", (byte) 10), // 体检-3
    DECLARE("未按照规定进行职业病危害项目申报；", (byte) 12), // 申报-1
    THREE_TIME("未按照规定落实建设项目的职业病防护设施“三同时”；", (byte) 13), // 三同时-5
    DETECTION("未按照规定对工作场所职业病危害因素进行检测、评价；", (byte) 14), // 检测-2
    PROTECTION("未按照规定提供符合要求的个人使用的职业病防护用品；", (byte) 15), // 个人防护-6
    WARNING_SIGNS ("未按照规定在产生严重职业病危害的作业岗位醒目位置设置警示标识和中文警示说明；", (byte) 16), // 警示标识-7
    TRAIN("用人单位的主要负责人、职业卫生管理人员未接受职业卫生培训；", (byte) 17), // 负责人培训-4
    ARCHIVES("未按照规定建立职业卫生档案；", (byte) 18), // 档案-8

    JCCB("存在检测结果超标风险未处置；", (byte) 3), // 档案-8
    JJZ("存在体检结果异常风险未整改；", (byte) 4), // 档案-8
    YSZYB("存在体检结果异常风险未整改；", (byte) 5), // 档案-8
    JCCBZG("存在监测结果超标风险未处置；", (byte) 21), // 档案-8

    ;

    private String name;
    private Byte value;

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return null;
        }
        for (PushRiskContentEnum level : PushRiskContentEnum.values()) {
            if (level.getValue().equals(value)) {
                return level.getName();
            }
        }
        return null;
    }

    public static PushRiskContentEnum getByType(Byte type) {
        for (PushRiskContentEnum reformGenerationSourceEnum : PushRiskContentEnum.values()) {
            if (reformGenerationSourceEnum.getValue().equals(type)) {
                return reformGenerationSourceEnum;
            }
        }
        return null;
    }
}

