package cn.smarthse.modules.health.enums.reform;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 整改与验收，验收结论
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月11日-下午1:43:40
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum AcceptanceResultEnum {

	/**
	 * 完成(整改验收完成)
	 */
	complete("完成",(byte) 1),
	/**
	 * 未完成()
	 */
	unComplete("未完成",(byte) 0),
	
	;

	// 成员变量
	private String name;
	private Byte value;
	// 构造方法
	
	private AcceptanceResultEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public Byte getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(Byte value) {
		this.value = value;
	}
	


}
