package cn.smarthse.modules.health.enums.planyear;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《年度计划-预算类别enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划预算>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PlanYearExpendTypeEnum {

	
	type1("职业卫生管理机构的组织工作经费",1),
	
	type2("生产车间改造费用",2),
	
	type3("生产工艺改进费用",3),
	
	type4("防护设施建设与维护费用",4),
	
	type5("个人劳动防护用品采购/维护费用",5),
	
	type6("工作场所职业卫生检测/评价费用",6),
	
	type7("职业病危害因素监测设备采购/维护费用",7),
	
	type8("职业卫生宣传培训费用",8),
	
	type9("职工职业健康监护费用",9),
	
	type10("职业病人诊疗费用",10),
	
	type11("警示标识采购费用",11),
	
	type12("其他",12),
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private PlanYearExpendTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (PlanYearExpendTypeEnum c : PlanYearExpendTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	public static PlanYearExpendTypeEnum getThisEnum(Integer value) {
		if (value == null) {
			return null;
		}
		for (PlanYearExpendTypeEnum c : PlanYearExpendTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
