package cn.smarthse.modules.health.enums.planyear;

/**
 * 
 * 《年度计划-详细计划类别enum》
 * 采用PlanYearModulars代替此枚举
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划详细计划>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */

public enum PlanYearDetailTypeEnum {

	
	type1("职业健康监护",1),
	
	type2("职业病危害因素监测",2),
	
	type3("教育培训",3),
	
	
	type4("防护设施维护",4),
	
	type5("个人防护用品采购",5),
	
	type6("隐患排查",6),
	
	type7("应急演练",7),
	
	type8("个人剂量监测",8),
	
	type9("职业病危害评价工作",9),
	
	type10("其他",10),
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private PlanYearDetailTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (PlanYearDetailTypeEnum c : PlanYearDetailTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
