/**
 * 
 */
package cn.smarthse.modules.health.enums.planyear;

/**
 * 《年度计划>实施方案>实施结果定义》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-4-上午10:05:16
 */
public enum PlanYearDetailImplState {
	/**
	 * 进行中
	 */
	progressing("进行中",(byte) 0),
	/**
	 * 已实施
	 */
	implemented("已完成",(byte) 1),
	/**
	 * 未实施
	 */
	unimplemented("未实施",(byte) 2),
	/**
	 * 已删除
	 */
	deleted("已删除",(byte)3),
	/**
	 * 已终止
	 */
	terminated("已终止",(byte) 4);
	
		// 成员变量
		private String name;
		private byte value;
		// 构造方法
		
		private PlanYearDetailImplState(String name, byte value) {
			this.name = name;
			this.value = value;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(byte value) {
			this.value = value;
		}
		
		/**
		 * 获取实施状态,默认返回进行中
		 * 
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author JannyShao(邵建义) [ksgameboy@qq.com]
		 * @since 2017-7-4-上午11:11:32
		 * @param value
		 * @return
		 */
		public static PlanYearDetailImplState get(Byte value) {
			if (value == null) {
				return progressing;
			}
			
			for (PlanYearDetailImplState c : PlanYearDetailImplState.values()) {
				if (c.getValue() == value.byteValue()) {
					return c;
				}
			}
			
			return progressing;
		}
}
