package cn.smarthse.modules.health.enums.msemergencyplan;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《应急预案类型enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.5.8>
 * @Comments:  <应急预案>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MsEmergencyPlanTypeEnum {

	
	type1("综合应急预案",1),
	
	type2("专项应急预案",2),
	
	type3("职业病危害事故专项应急预案",3),
	
	type4("现场处置方案",4),
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private MsEmergencyPlanTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (MsEmergencyPlanTypeEnum c : MsEmergencyPlanTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
