package cn.smarthse.modules.health.enums.material;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《物料计量单位enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-6-15-上午9:59:22
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum UnitOfMeasurementEnum {

	
	Measurement1("万吨（10^4t）",1),
	
	Measurement2("吨（t）",2),
	
	Measurement3("千克（kg）",3),
	
	Measurement4("克（g）",4),
	
	Measurement5("毫克（mg）",5),
	
	Measurement6("千米（km）",6),
	
	Measurement7("米（m）",7),
	
	Measurement8("分米（dm）",8),
	
	Measurement9("厘米（cm）",9),
	
	Measurement10("毫米（mm）",10),
	
	Measurement11("平方千米（km2）",11),
	
	Measurement12("平方米（m2）",12),
	
	Measurement13("平方厘米（cm2）",13),
	
	Measurement14("万立方米（万m3）",14),
	
	Measurement15("立方米（m3）",15),
	
	Measurement16("升（L）",16),
	
	Measurement25("毫升（ML）",25),
	
	Measurement17("个",17),
	
	Measurement18("件",18),
	
	Measurement19("套",19),
	
	Measurement20("瓶",20),
	
	Measurement21("桶",21),
	
	Measurement22("盒",22),
	
	Measurement23("箱",23),
	
	Measurement24("台",24),
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private UnitOfMeasurementEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (UnitOfMeasurementEnum c : UnitOfMeasurementEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	// 普通方法
	public static Integer getValue(String name) {
		if (name == null) {
			return null;
		}
		for (UnitOfMeasurementEnum c : UnitOfMeasurementEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
