package cn.smarthse.modules.health.enums.material;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《产品类别enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-6-15-上午9:59:22
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ProductTypeEnum {

	
	intermediateProducts("中间产品",3),
	
	product("产品",4),
	
	ByProduct("副产品",5),
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private ProductTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (ProductTypeEnum c : ProductTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	// 普通方法
	public static Integer getValue(String name) {
		if (name == null) {
			return null;
		}
		for (ProductTypeEnum c : ProductTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
