package cn.smarthse.modules.health.enums.material;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物料类别enum————职业健康在线
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum MaterialTypeIsZjProjEnum {

    raw("原料", 1),
    Accessories("辅料", 2),
    product("产品", 4),
    ;

    private String name;
    private Integer value;

    private MaterialTypeIsZjProjEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (MaterialTypeIsZjProjEnum c : MaterialTypeIsZjProjEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static Integer getValue(String name) {
        if (name == null) {
            return null;
        }
        for (MaterialTypeIsZjProjEnum c : MaterialTypeIsZjProjEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer index) {
        this.value = index;
    }
}