package cn.smarthse.modules.health.enums.init;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 《初始化enum》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <初始化>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi
 * @since 2017-7-25 9:30
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum InitStepEnum {

	
	firstStep("第一步",1),
	
	secondStep("第二步",2),
	
	thirdStep("第三步",3),
	
	fourthStep("第四步",4),
	
	fifthStep("第五步",5),
	
	sixthStep("第六步",6),
	
	
	; 
	
	// 成员变量
	private String name;
	private Integer value;
	// 构造方法

	private InitStepEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	// 普通方法
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (InitStepEnum c : InitStepEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer index) {
		this.value = index;
	}
}
