package cn.smarthse.modules.health.enums.hccheckplan;

import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 《检测结果单位》
 * 
 * 
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2020年3月12日-上午11:39:27
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum UnitOfCheckResultEnum {
	//化学
	CHEMICAL_cmac("cmac",(byte)1,"mg/m³","C<sub>ME</sub>(mg/m³)",null),
	CHEMICAL_ctwa("ctwa",(byte)1,"mg/m³","C<sub>TWA</sub>(mg/m³)",null),
	CHEMICAL_cstel("cstel",(byte)1,"mg/m³","C<sub>STE</sub>(mg/m³)",null),
	CHEMICAL_times("times",(byte)1,"","超限倍数",null),
	CHEMICAL_peakcontactconcentration("peakcontactconcentration",(byte)1,"mg/m³","峰接触浓度(mg/m³)",null),
	
	//粉尘
	DUST_ctwa1("ctwa1",(byte)2,"mg/m³","C<sub>TWA总尘</sub>(mg/m³)",null),
	DUST_ctwa1range("ctwa1range",(byte)2,"mg/m³","浓度范围(mg/m³)",null),
	DUST_times1("times1",(byte)2,"","超限倍数(总尘)",null),
	DUST_peakcontactconcentration1("peakcontactconcentration1",(byte)2,"mg/m³","峰接触浓度(mg/m³)",null),
	DUST_ctwa2("ctwa2",(byte)2,"mg/m³","C<sub>TWA呼尘</sub>(mg/m³)",null),
	DUST_ctwa2range("ctwa2range",(byte)2,"mg/m³","浓度范围(mg/m³)",null),
	DUST_times2("times2",(byte)2,"","超限倍数(呼尘)",null),
	DUST_peakcontactconcentration2("peakcontactconcentration2",(byte)2,"mg/m³","峰接触浓度(mg/m³)",null),
	
	//生物因素 白僵蚕孢子（可能用不上）
	BIOLOGICAL_SW7_cmac("cmac1",(byte)3,"孢子数/m³","C<sub>MAC</sub>(孢子数/m³)",596L),
	BIOLOGICAL_SW7_ctwa("ctwa1",(byte)3,"孢子数/m³","C<sub>TWA</sub>(孢子数/m³)",596L),
	BIOLOGICAL_SW7_cstel("cstel",(byte)3,"孢子数/m³","C<sub>STEL</sub>(孢子数/m³)",596L),
	
	//生物因素 枯草杆菌蛋白酶（可能用不上）
	BIOLOGICAL_SW8_cmac("cmac1",(byte)3,"孢子数/m³","C<sub>MAC</sub>(孢子数/m³)",597L),
	BIOLOGICAL_SW8_ctwa("ctwa1",(byte)3,"孢子数/m³","C<sub>TWA</sub>(孢子数/m³)",597L),
	BIOLOGICAL_SW8_cstel("cstel",(byte)3,"孢子数/m³","C<sub>STEL</sub>(孢子数/m³)",597L),
	
	BIOLOGICAL_other_cmac("cmac1",(byte)3,"孢子数/m³","C<sub>MAC</sub>",null),
	BIOLOGICAL_other_ctwa("ctwa1",(byte)3,"孢子数/m³","C<sub>TWA</sub>",null),
	BIOLOGICAL_other_cstel("cstel",(byte)3,"孢子数/m³","C<sub>STEL</sub>",null),
	
	//噪声
	NOISE_times("times",(byte)4,"次","工作日接触脉冲次数(次)",567L),
	NOISE_maxnoise("maxnoise",(byte)4,"dB(A)","声压级峰值[dB(A)]",567L),
	NOISE_checkvalue("checkvalue",(byte)4,"dB(A)","检测数值[dB(A)]",567L),
	NOISE_minvalue("minvalue",(byte)4,"dB(A)","最低值[dB(A)]",567L),
	NOISE_equallevel("equallevel",(byte)4,"dB(A)","8/40h等效声级[dB(A)]",567L),
	NOISE_maxvalue("maxvalue",(byte)4,"dB(A)","最高值[dB(A)]",567L),
	
	//高频电磁场
	HIGHFREQUENCY_frequency("frequency",(byte)5,"(f,MHz)","频率(f,MHz)",579L),
	HIGHFREQUENCY_time("time",(byte)5,"h","接触时间(h)",579L),
	HIGHFREQUENCY_estrong("estrong",(byte)5,"V/m","电场强度(V/m)",579L),
	HIGHFREQUENCY_mstrong("mstrong",(byte)5,"V/m","磁场强度(A/m)",579L),
	
	//电离辐射（数据库有变更）
	IONIZINGRADIATION_checkresult("checkresult",(byte)6,"μSv/h","检测结果(μSv/h)",704L),
	
	//超高频辐射
	ULTRAHIGHFREQUENCYRADIATION_time("time",(byte)7,"h","接触时间(h)",580L),
	ULTRAHIGHFREQUENCYRADIATION_power("power",(byte)7,"mW/cm<sup>2</sup>","功率密度(mW/cm<sup>2</sup>)",580L),
	ULTRAHIGHFREQUENCYRADIATION_electric("electric",(byte)7,"V/m","电场强度(V/m)",580L),
	
	//手传振动
	HANDTRANSMITTED_time("time",(byte)8,"h","接触时间(h)",572L),
	HANDTRANSMITTED_speed("speed",(byte)8,"m/s<sup>2</sup>","4h等能量频率计权振动加速度(m/s<sup>2</sup>)",572L),
	
	//微波辐射
	MICROWAVERADIATION_time("time",(byte)9,"h","受辐射时间(h)",575L),
	MICROWAVERADIATION_amount("amount",(byte)9,"μW·h/cm<sup>2</sup>","日剂量(μW·h/cm<sup>2</sup>)",575L),
	MICROWAVERADIATION_avgdensity("avgdensity",(byte)9,"μW/cm<sup>2</sup>","平均功率密度(μW/cm<sup>2</sup>)",575L),
	MICROWAVERADIATION_powerdensity("powerdensity",(byte)9,"mW/cm<sup>2</sup>","短时间接触功率密度(mW/cm<sup>2</sup>)",575L),
	
	//紫外辐射
	ULTRAVIOLETLIGHT_time("time",(byte)10,"h","接触时间(h)",576L),
	ULTRAVIOLETLIGHT_irradiance("irradiance",(byte)10,"μW/cm<sup>2</sup>","辐照度(μW/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_exposure("exposure",(byte)10,"mJ/cm<sup>2</sup>","照射量(mJ/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_irradiance1("irradiance1",(byte)10,"μW/cm<sup>2</sup>","辐照度(μW/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_exposure1("exposure1",(byte)10,"mJ/cm<sup>2</sup>","照射量(mJ/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_irradiance2("irradiance2",(byte)10,"μW/cm<sup>2</sup>","辐照度(μW/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_exposure2("exposure2",(byte)10,"mJ/cm<sup>2</sup>","照射量(mJ/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_irradiance3("irradiance3",(byte)10,"μW/cm<sup>2</sup>","辐照度(μW/cm<sup>2</sup>)",576L),
	ULTRAVIOLETLIGHT_exposure3("exposure3",(byte)10,"mJ/cm<sup>2</sup>","照射量(mJ/cm<sup>2</sup>)",576L),
	
	//工频电场
	POWERFREQUENCY_time("time",(byte)11,"h","接触时间(h)",578L),
	POWERFREQUENCY_power("power",(byte)11,"kV/m","电场强度（kV/m）",578L),
	
	//高温
	HIGHTEMPERATURE_time("time",(byte)12,"%","接触时间率(%)",568L),
	HIGHTEMPERATURE_checkresult("checkresult",(byte)12,"℃","检测结果℃",568L),
	
	//激光辐射
	LASERRADIATION_time("time",(byte)13,"h","接触时间(h)",573L),
	LASERRADIATION_wavelength("wavelength",(byte)13,"n/m","波长(n/m)",573L),
	LASERRADIATION_irradiationtime("irradiationtime",(byte)13,"s","照射时间(s)",573L),
	LASERRADIATION_exposure("exposure",(byte)13,"J/cm<sup>2</sup>","照射量(J/cm<sup>2</sup>)",573L),
	LASERRADIATION_irradiance("irradiance",(byte)13,"W/cm<sup>2</sup>","辐照度(W/cm<sup>2</sup>)",573L),
	;
	 /**
	 * 结果单位 在结果汇总的key名称
	 */
	private String keyName;
	 
	/**
	 * 结果汇总的大类型
	 */
	private Byte  collectType;
	
	/**
	 * 单位
	 */
	private  String unit;
	
	private  Long  harmId;
	
	/**
	 * 表头名称
	 */
	private  String titleName;
	
    private UnitOfCheckResultEnum(String keyName,Byte  collectType,String unit
    		,String titleName,Long harmId) {
		this.keyName=keyName;
		this.collectType=collectType;
		this.unit=unit;
		this.titleName=titleName;
		this.harmId=harmId;
	}
	
	public String getKeyName() {
		return keyName;
	}

	public Byte getCollectType() {
		return collectType;
	}

	public String getUnit() {
		return unit;
	}

	public String getTitleName() {
		return titleName;
	}
	public Long getHarmId() {
		return harmId;
	}
	
	public static UnitOfCheckResultEnum getThisEnumByKeyNameAndCollectTypeAndHarmId(String keyName,Byte  collectType,
    		Long harmId) {
		//对生物进行特殊处理
		UnitOfCheckResultEnum[]  list=UnitOfCheckResultEnum.values();
		for (UnitOfCheckResultEnum en : list) {
			boolean flag=false;
			if (collectType == 3) {
				if (harmId != null && (harmId.equals(596L) || harmId.equals(597L))) {
					if(en.getKeyName().equals(keyName)&&harmId.equals(en.getHarmId())) {
						return en;
					}
				} else {
					flag=true;
				}
			}else if(collectType<14){
				flag=true;
			}
			if(flag&&en.getKeyName().equals(keyName)) {
				if(collectType==1||collectType==2) {
					return en;
				}else  if(harmId.equals(en.getHarmId())) {
					return en;
				}
				
				
			}

		}
		
		
		return null;
	}

	
}